/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: PGPmenuMESP.cp,v 1.13.4.1 1999/06/04 22:21:27 heller Exp $
____________________________________________________________________________*/

#include <A4Stuff.h>

#include "pgpClientPrefs.h"
#include "pgpMemoryMgr.h"
#include "pgpOpenPrefs.h"
#include "MacErrors.h"
#include "MacStrings.h"
#include "StPGPRefs.h"

#include "plugin.h"
#include "PGPmenuMESP.h"


namespace {
	const OSType		kFinderSignature			=	'MACS';
	const ProcInfoType	kUPPPGPmenuMainProcInfo		=	kThinkCStackBased
							| RESULT_SIZE(SIZE_CODE(sizeof(SInt32)))
							| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(ProcessInfoRec *)))
							| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(FSSpec *)))
							| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(SPGPmenuMESPData *)));
	const SInt32		kDefaultAdditionalMemory	=	300;
	const StringPtr		kOutOfMemoryStringPrefix	=	"\pThere is not enough memory to load "
														"PGPmenu in this application. Please "
														"increase the application's "
														"Minimum Memory Requirement by ";
	const StringPtr		kOutOfMemoryStringSuffix	=	"\pK.";
	const StringPtr		kErrorStringPrefix			=	"\pUnable to load PGPmenu because an "
														"error (";
	const StringPtr		kErrorStringSuffix			=	"\p) occured.";
}

/*
#include <stdio.h>
#define PGPThrowPGPError_(inError)																\
	do {																						\
		char temp[128];																			\
																								\
		sprintf(temp, "MESP exception: %ld File: %s Line: %d", inError, __FILE__, __LINE__);	\
		c2pstr(temp);																			\
		DebugStr((StringPtr) temp);																\
		throw (static_cast<PGPError>(inError));													\
	} while (0)
	
#define PGPThrowOSError_(inError)																\
	do {																						\
		char temp[128];																			\
																								\
		sprintf(temp, "MESP exception: %ld File: %s Line: %d", inError, __FILE__, __LINE__);	\
		c2pstr(temp);																			\
		DebugStr((StringPtr) temp);																\
		throw (static_cast<PGPError>(inError));													\
	} while (0)
*/

#define PGPThrowPGPError_(inError)					throw (static_cast<PGPError>(inError))
#define PGPThrowOSError_(inError)					throw (static_cast<PGPError>(inError))
#define PGPThrowIfPGPError_(inError)									\
	if ((inError) != kPGPError_NoErr) {									\
		PGPThrowPGPError_(inError);										\
	}
#define PGPThrowIfOSError_(inError)										\
	if ((inError) != noErr) {											\
		PGPThrowOSError_(inError);										\
	}
#define	PGPThrowIfResError_()	PGPThrowIfOSError_(ResError())
#define PGPThrowIfResFail_(inHandle)									\
	if ((inHandle) == 0) {												\
		OSStatus __theError = ResError();								\
		if (__theError == noErr) {										\
			__theError = resNotFound;									\
		}																\
		PGPThrowOSError_(__theError);									\
	}
#define PGPThrowIfNULL_(inPointer)										\
	if ((inPointer) == 0) {												\
		PGPThrowPGPError_(kPGPError_BadMemAddress);						\
	}
#define	PGPThrowIfNot_(inTest)											\
		if (! (inTest)) {												\
			PGPThrowPGPError_(kPGPError_AssertFailed);					\
		}


struct SMenuApps {
	PGPBoolean	usesPrivateScrap;
	PGPBoolean	usesOutputDialog;
	OSType		creator;
	Str31		name;
};



class	StResourceFile {
public:
				StResourceFile(FSSpec * inFSSpec)
					{ mFileRef = ::FSpOpenResFile(inFSSpec, fsRdPerm); PGPThrowIfResError_(); }
				~StResourceFile()
					{ if (mFileRef != -1) ::CloseResFile(mFileRef); }
protected:
	PGPInt16	mFileRef;
};


class	StHeapZone {
public:
				StHeapZone()
					{ mZone = ::GetZone(); }
				~StHeapZone()
					{ Restore(); }
	void		Restore()
					{ ::SetZone(mZone); }
protected:
	THz			mZone;
};



class	StConnectionID {
public:
						StConnectionID()
							{ mClose = false; }
						~StConnectionID()
							{ if (mClose) ::CloseConnection(&mConnection); }
	void				SetClose(PGPBoolean inClose)
							{ mClose = inClose; }
	CFragConnectionID *	operator&()
							{ return &mConnection; }
protected:
	PGPBoolean			mClose;
	CFragConnectionID	mConnection;
};



typedef StPGPRef<Handle>	StResource;
inline void StResource::Dispose() { ::ReleaseResource(mRef); }

typedef StPGPRef<UniversalProcPtr> StRoutineDescriptorTrap;
inline void StRoutineDescriptorTrap::Dispose() { ::DisposeRoutineDescriptorTrap(mRef); }



	static PGPBoolean
CaptureThisApp(
	OSType			inCreator,
	PGPBoolean *	outUsesOutputDialog)
{
	PGPBoolean			result;
	
	if (inCreator == kFinderSignature) {
		result = true;
	} else {
		
		PGPError			pgpErr;
		StPGPMemoryMgrRef	memoryMgr;
		StPGPPrefRef		prefRef;
		SMenuApps *			apps;
		PGPSize				len;
		PGPUInt32			numApps;
		
		result = false;
		pgpErr = PGPNewMemoryMgr(0, &memoryMgr);
		PGPThrowIfPGPError_(pgpErr);
		pgpErr = PGPOpenClientPrefs(memoryMgr, &prefRef);
		PGPThrowIfPGPError_(pgpErr);
		pgpErr = PGPGetPrefData(prefRef, kPGPPrefPGPmenuMacAppSignatures, &len, &apps);
		PGPThrowIfPGPError_(pgpErr);
		numApps = len / sizeof(SMenuApps);
		for (PGPUInt32 x = 0; x < numApps; x++) {
			if (apps[x].creator == inCreator) {
				*outUsesOutputDialog = apps[x].usesOutputDialog;
				result = true;
				break;
			}
		}
		PGPDisposePrefData(prefRef, apps);
	}
	
	return result;
}


	static void
NotifyOfError(
	PGPError	inPGPError,
	PGPInt32	inAddMemoryRequired)
{
	StringPtr	errorString;
	NMRecPtr	note;
	StringPtr	prefix;
	StringPtr	suffix;
	Str32		number;
	
	if ((inPGPError == kPGPError_OutOfMemory) && (inAddMemoryRequired > 0)) {
		prefix = kOutOfMemoryStringPrefix;
		suffix = kOutOfMemoryStringSuffix;
		::NumToString(inAddMemoryRequired, number);
	} else {
		prefix = kErrorStringPrefix;
		suffix = kErrorStringSuffix;
		::NumToString(inPGPError, number);
	}
	errorString = reinterpret_cast<StringPtr>(::NewPtr(256));
	if (errorString != 0) {
		note = reinterpret_cast<NMRecPtr>(::NewPtrClear(sizeof(NMRec)));
		if (note != 0) {
			CopyPString(prefix, errorString);
			AppendPString(number, errorString);
			AppendPString(suffix, errorString);
			note->qType = nmType;
			note->nmSound = reinterpret_cast<Handle>(-1);
			note->nmStr = errorString;
			note->nmResp = reinterpret_cast<NMUPP>(-1);
			::NMInstall(note);
		} else {
			::DisposePtr(reinterpret_cast<Ptr>(errorString));
		}
	}
}

	SInt32
main(
	ProcessInfoRec *	inProcInfo,
	FSSpec *			inFSSpec)
{
	EnterCodeResource();
	
	static const	SInt32	kDefaultAdditionalMemoryRequired = 300;
	SInt32					addMemRequired = 0;
	
	try {
		// Check for CFM and if we should capture this app
		StResourceFile		theFile(inFSSpec);
		OSStatus			err;
		PGPError			pgpErr;
		SInt32				response;
		SPGPmenuMESPData	pgpMenuData;
		
		err = ::Gestalt(gestaltCFMAttr, &response);
		PGPThrowIfOSError_(err);
		PGPThrowIfNot_((response >> gestaltCFMPresent) & 1);
		if (CaptureThisApp(inProcInfo->processSignature, &pgpMenuData.usesOutputDialog)) {
			// Load the correct library
			StHeapZone				zoneSaver;
			StConnectionID			connID;
			StResource				cfrgHandle;
			CFragResourceMemberPtr	member;
			Ptr						mainEntryPoint;
			Str255					errName;
			SInt32					beforeMem;
			SInt32					afterMem;
			SInt32					contig;
			
			cfrgHandle = ::Get1Resource(kCFragResourceType, kCFragResourceID);
			PGPThrowIfResFail_(cfrgHandle);
			::HLock(cfrgHandle);
			member = &(**reinterpret_cast<CFragResourceHandle>(
				static_cast<Handle>(cfrgHandle))).firstMember;
			if (inProcInfo->processSignature == kFinderSignature) {
				::SetZone(::SystemZone());
			} else {
				((Ptr) member) += member->memberSize; // PGPmenuApp is the second member of the cfrg
			}
			if (inProcInfo->processSignature != kFinderSignature) {
				addMemRequired = kDefaultAdditionalMemory;
				::PurgeSpace(&beforeMem, &contig);
			}
			err = ::GetDiskFragment(inFSSpec, member->offset, member->length, member->name, kLoadCFrag,
				&connID, reinterpret_cast<Ptr *>(&mainEntryPoint), errName);
			if (err == cfragNoClientMemErr) {
				addMemRequired = kDefaultAdditionalMemoryRequired;
				PGPThrowPGPError_(kPGPError_OutOfMemory);
			}
			PGPThrowIfOSError_(err);
			connID.SetClose(true);
			if (inProcInfo->processSignature != kFinderSignature) {
				::PurgeSpace(&afterMem, &contig);
				addMemRequired = (beforeMem - (2 * afterMem)) / 1024;
				if (addMemRequired > 0) {
					PGPThrowPGPError_(kPGPError_OutOfMemory);
				}
			}
			cfrgHandle.Free();
			
			// Create and call the UPP
			StRoutineDescriptorTrap	pgpMenuMainUPP;
			
			pgpMenuMainUPP = ::NewRoutineDescriptorTrap(reinterpret_cast<ProcPtr>(mainEntryPoint),
				kUPPPGPmenuMainProcInfo, kPowerPCISA | kPowerPCRTA);
			PGPThrowIfNULL_(pgpMenuMainUPP);
			pgpErr = reinterpret_cast<PGPmenuMain>(static_cast<UniversalProcPtr>(pgpMenuMainUPP))(
				inProcInfo, inFSSpec, &pgpMenuData);
			PGPThrowIfPGPError_(pgpErr);
			connID.SetClose(false);
		}
	}
	
	catch (PGPError &	error) {
		if ((error < kPGPPFLErrorBase) || (error > kPGPError_Last)) {
			error = MacErrorToPGPError(error);
		}
		NotifyOfError(error, addMemRequired);
	}
	
	catch (...) {
		NotifyOfError(kPGPError_UnknownError, 0);
	}
	
	ExitCodeResource();
	return kUnloadPlug;
}